/*
 * Decompiled with CFR 0.152.
 */
package jdiff;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import jdiff.ClassAPI;
import jdiff.CommentsHandler;
import jdiff.HTMLReportGenerator;
import jdiff.PackageAPI;
import jdiff.RootDocToXML;
import jdiff.SingleComment;
import jdiff.XMLToAPI;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Comments {
    public static Hashtable allPossibleComments = new Hashtable();
    private static Comments oldComments_ = null;
    public List commentsList_ = new ArrayList();
    public static final String placeHolderText = "InsertCommentsHere";
    private static List oldAPIList = null;
    private static List newAPIList = null;
    private static PrintWriter outputFile = null;

    public static Comments readFile(String filename) {
        File f;
        if (XMLToAPI.validateXML) {
            Comments.writeXSD(filename);
        }
        if (!(f = new File(filename)).exists()) {
            return null;
        }
        oldComments_ = new Comments();
        try {
            CommentsHandler handler = new CommentsHandler(oldComments_);
            XMLReader parser = null;
            try {
                String parserName = System.getProperty("org.xml.sax.driver");
                parser = parserName == null ? XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser") : XMLReaderFactory.createXMLReader();
            }
            catch (SAXException saxe) {
                System.out.println("SAXException: " + saxe);
                saxe.printStackTrace();
                System.exit(1);
            }
            if (XMLToAPI.validateXML) {
                parser.setFeature("http://xml.org/sax/features/namespaces", true);
                parser.setFeature("http://xml.org/sax/features/validation", true);
                parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            parser.setContentHandler(handler);
            parser.setErrorHandler(handler);
            parser.parse(new InputSource(new FileInputStream(new File(filename))));
        }
        catch (SAXNotRecognizedException snre) {
            System.out.println("SAX Parser does not recognize feature: " + snre);
            snre.printStackTrace();
            System.exit(1);
        }
        catch (SAXNotSupportedException snse) {
            System.out.println("SAX Parser feature is not supported: " + snse);
            snse.printStackTrace();
            System.exit(1);
        }
        catch (SAXException saxe) {
            System.out.println("SAX Exception parsing file '" + filename + "' : " + saxe);
            saxe.printStackTrace();
            System.exit(1);
        }
        catch (IOException ioe) {
            System.out.println("IOException parsing file '" + filename + "' : " + ioe);
            ioe.printStackTrace();
            System.exit(1);
        }
        Collections.sort(Comments.oldComments_.commentsList_);
        return oldComments_;
    }

    public static void writeXSD(String filename) {
        String xsdFileName = filename;
        int idx = xsdFileName.lastIndexOf(92);
        int idx2 = xsdFileName.lastIndexOf(47);
        if (idx == -1 && idx2 == -1) {
            xsdFileName = "";
        } else if (idx == -1 && idx2 != -1) {
            xsdFileName = xsdFileName.substring(0, idx2 + 1);
        } else if (idx != -1 && idx2 == -1) {
            xsdFileName = xsdFileName.substring(0, idx + 1);
        } else if (idx != -1 && idx2 != -1) {
            int max = idx2 > idx ? idx2 : idx;
            xsdFileName = xsdFileName.substring(0, max + 1);
        }
        xsdFileName = xsdFileName + "comments.xsd";
        try {
            FileOutputStream fos = new FileOutputStream(xsdFileName);
            PrintWriter xsdFile = new PrintWriter(fos);
            xsdFile.println("<?xml version=\"1.0\" encoding=\"iso-8859-1\" standalone=\"no\"?>");
            xsdFile.println("<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
            xsdFile.println();
            xsdFile.println("<xsd:annotation>");
            xsdFile.println("  <xsd:documentation>");
            xsdFile.println("  Schema for JDiff comments.");
            xsdFile.println("  </xsd:documentation>");
            xsdFile.println("</xsd:annotation>");
            xsdFile.println();
            xsdFile.println("<xsd:element name=\"comments\" type=\"commentsType\"/>");
            xsdFile.println();
            xsdFile.println("<xsd:complexType name=\"commentsType\">");
            xsdFile.println("  <xsd:sequence>");
            xsdFile.println("    <xsd:element name=\"comment\" type=\"commentType\" minOccurs='0' maxOccurs='unbounded'/>");
            xsdFile.println("  </xsd:sequence>");
            xsdFile.println("  <xsd:attribute name=\"name\" type=\"xsd:string\"/>");
            xsdFile.println("  <xsd:attribute name=\"jdversion\" type=\"xsd:string\"/>");
            xsdFile.println("</xsd:complexType>");
            xsdFile.println();
            xsdFile.println("<xsd:complexType name=\"commentType\">");
            xsdFile.println("  <xsd:sequence>");
            xsdFile.println("    <xsd:element name=\"identifier\" type=\"identifierType\" minOccurs='1' maxOccurs='unbounded'/>");
            xsdFile.println("    <xsd:element name=\"text\" type=\"xsd:string\" minOccurs='1' maxOccurs='1'/>");
            xsdFile.println("  </xsd:sequence>");
            xsdFile.println("</xsd:complexType>");
            xsdFile.println();
            xsdFile.println("<xsd:complexType name=\"identifierType\">");
            xsdFile.println("  <xsd:attribute name=\"id\" type=\"xsd:string\"/>");
            xsdFile.println("</xsd:complexType>");
            xsdFile.println();
            xsdFile.println("</xsd:schema>");
            xsdFile.close();
        }
        catch (IOException e) {
            System.out.println("IO Error while attempting to create " + xsdFileName);
            System.out.println("Error: " + e.getMessage());
            System.exit(1);
        }
    }

    public void addComment(SingleComment comment) {
        this.commentsList_.add(comment);
    }

    public static String getComment(Comments comments, String id) {
        if (comments == null) {
            return placeHolderText;
        }
        SingleComment key = new SingleComment(id, null);
        int idx = Collections.binarySearch(comments.commentsList_, key);
        if (idx < 0) {
            return placeHolderText;
        }
        int startIdx = comments.commentsList_.indexOf(key);
        int endIdx = comments.commentsList_.indexOf(key);
        int numIdx = endIdx - startIdx + 1;
        if (numIdx != 1) {
            System.out.println("Warning: " + numIdx + " identical ids in the existing comments file. Using the first instance.");
        }
        SingleComment singleComment = (SingleComment)comments.commentsList_.get(idx);
        return singleComment.text_;
    }

    public static String convertAtLinks(String text, String currentElement, PackageAPI pkg, ClassAPI cls) {
        if (text == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int state = -1;
        int NORMAL_TEXT = -1;
        boolean IN_LINK = true;
        int IN_LINK_IDENTIFIER = 2;
        int IN_LINK_IDENTIFIER_REFERENCE = 3;
        int IN_LINK_IDENTIFIER_REFERENCE_PARAMS = 6;
        int IN_LINK_LINKTEXT = 4;
        int END_OF_LINK = 5;
        StringBuffer identifier = null;
        StringBuffer identifierReference = null;
        StringBuffer linkText = null;
        String ref = "";
        if (currentElement.compareTo("class") == 0 || currentElement.compareTo("interface") == 0) {
            ref = pkg.name_ + "." + cls.name_ + ".";
        } else if (currentElement.compareTo("package") == 0) {
            ref = pkg.name_ + ".";
        }
        ref = ref.replace('.', '/');
        block9: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            char nextChar = i < text.length() - 1 ? (char)text.charAt(i + 1) : (char)'\uffff';
            int remainingChars = text.length() - i;
            switch (state) {
                case -1: {
                    if (c == '{' && remainingChars >= 5 && "{@link".equals(text.substring(i, i + 6))) {
                        state = 1;
                        identifier = null;
                        identifierReference = null;
                        linkText = null;
                        i += 5;
                        continue block9;
                    }
                    result.append(c);
                    continue block9;
                }
                case 1: {
                    if (Character.isWhitespace(nextChar)) continue block9;
                    if (nextChar == '}') {
                        state = 5;
                        continue block9;
                    }
                    if (Character.isWhitespace(nextChar)) continue block9;
                    state = 2;
                    continue block9;
                }
                case 2: {
                    if (identifier == null) {
                        identifier = new StringBuffer();
                    }
                    if (c == '#') {
                        state = 3;
                        continue block9;
                    }
                    if (Character.isWhitespace(c)) {
                        state = 4;
                        continue block9;
                    }
                    identifier.append(c);
                    if (nextChar != 125) continue block9;
                    state = 5;
                    continue block9;
                }
                case 3: {
                    if (identifierReference == null) {
                        identifierReference = new StringBuffer();
                    }
                    if (Character.isWhitespace(c)) {
                        state = 4;
                        continue block9;
                    }
                    identifierReference.append(c);
                    if (c == '(') {
                        state = 6;
                    }
                    if (nextChar != 125) continue block9;
                    state = 5;
                    continue block9;
                }
                case 6: {
                    if (c == ')') {
                        state = 3;
                    }
                    identifierReference.append(c);
                    if (nextChar != 125) continue block9;
                    state = 5;
                    continue block9;
                }
                case 4: {
                    if (linkText == null) {
                        linkText = new StringBuffer();
                    }
                    linkText.append(c);
                    if (nextChar != 125) continue block9;
                    state = 5;
                    continue block9;
                }
                case 5: {
                    if (identifier != null) {
                        result.append("<A HREF=\"");
                        result.append(HTMLReportGenerator.newDocPrefix);
                        result.append(ref);
                        result.append(identifier.toString().replace('.', '/'));
                        result.append(".html");
                        if (identifierReference != null) {
                            result.append("#");
                            result.append(identifierReference);
                        }
                        result.append("\">");
                        result.append("<TT>");
                        if (linkText != null) {
                            result.append(linkText);
                        } else {
                            result.append(identifier);
                            if (identifierReference != null) {
                                result.append(".");
                                result.append(identifierReference);
                            }
                        }
                        result.append("</TT>");
                        result.append("</A>");
                    }
                    state = -1;
                }
            }
        }
        return result.toString();
    }

    public static boolean writeFile(String outputFileName, Comments newComments) {
        try {
            FileOutputStream fos = new FileOutputStream(outputFileName);
            outputFile = new PrintWriter(fos);
            newComments.emitXMLHeader(outputFileName);
            newComments.emitComments();
            newComments.emitXMLFooter();
            outputFile.close();
        }
        catch (IOException e) {
            System.out.println("IO Error while attempting to create " + outputFileName);
            System.out.println("Error: " + e.getMessage());
            System.exit(1);
        }
        return true;
    }

    public void emitComments() {
        for (SingleComment currComment : this.commentsList_) {
            if (!currComment.isUsed_) {
                outputFile.println("<!-- This comment is no longer used ");
            }
            outputFile.println("<comment>");
            outputFile.println("  <identifier id=\"" + currComment.id_ + "\"/>");
            outputFile.println("  <text>");
            outputFile.println("    " + currComment.text_);
            outputFile.println("  </text>");
            outputFile.println("</comment>");
            if (currComment.isUsed_) continue;
            outputFile.println("-->");
        }
    }

    public void dump() {
        Iterator iter = this.commentsList_.iterator();
        int i = 0;
        while (iter.hasNext()) {
            SingleComment currComment = (SingleComment)iter.next();
            System.out.println("Comment " + ++i);
            System.out.println("id = " + currComment.id_);
            System.out.println("text = \"" + currComment.text_ + "\"");
            System.out.println("isUsed = " + currComment.isUsed_);
        }
    }

    public static void noteDifferences(Comments oldComments, Comments newComments) {
        if (oldComments == null) {
            System.out.println("Note: all the comments have been newly generated");
            return;
        }
        for (SingleComment oldComment : oldComments.commentsList_) {
            int idx = Collections.binarySearch(newComments.commentsList_, oldComment);
            if (idx >= 0) continue;
            System.out.println("Warning: comment \"" + oldComment.id_ + "\" is no longer used.");
            oldComment.isUsed_ = false;
            newComments.commentsList_.add(oldComment);
        }
    }

    public void emitXMLHeader(String filename) {
        outputFile.println("<?xml version=\"1.0\" encoding=\"iso-8859-1\" standalone=\"no\"?>");
        outputFile.println("<comments");
        outputFile.println("  xmlns:xsi='" + RootDocToXML.baseURI + "/2001/XMLSchema-instance'");
        outputFile.println("  xsi:noNamespaceSchemaLocation='comments.xsd'");
        int idx = filename.lastIndexOf(46);
        String apiIdentifier = filename.substring(0, idx);
        if (HTMLReportGenerator.outputDir != null) {
            apiIdentifier = apiIdentifier.substring(HTMLReportGenerator.outputDir.length() + 1);
        }
        apiIdentifier = apiIdentifier.substring(18);
        outputFile.println("  name=\"" + apiIdentifier + "\"");
        outputFile.println("  jdversion=\"1.1.1\">");
        outputFile.println();
        outputFile.println("<!-- This file contains comments for a JDiff report. -->");
        outputFile.println("<!-- It is used only in generating the report, and does not need to ship with the final report. -->");
        outputFile.println();
        outputFile.println("<!-- The id attribute in an identifier element identifies the change as noted in the report. -->");
        outputFile.println("<!-- An id has the form package[.class[.[ctor|method|field].signature]], where [] indicates optional text. -->");
        outputFile.println("<!-- A comment element can have multiple identifier elements, which will -->");
        outputFile.println("<!-- will cause the same text to appear at each place in the report, but -->");
        outputFile.println("<!-- will be converted to separate comments when the comments file is used. -->");
        outputFile.println("<!-- HTML tags in the text field will appear in the report. -->");
        outputFile.println("<!-- You also need to close p HTML elements, used for paragraphs - see the top-level documentation. -->");
    }

    public void emitXMLFooter() {
        outputFile.println();
        outputFile.println("</comments>");
    }

    public static boolean isMinimizedTag(String tag) {
        return tag.equalsIgnoreCase("p") || tag.equalsIgnoreCase("br") || tag.equalsIgnoreCase("hr");
    }
}

