/*
 * Decompiled with CFR 0.152.
 */
package jdiff;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import jdiff.API;
import jdiff.APIHandler;
import jdiff.ClassAPI;
import jdiff.ConstructorAPI;
import jdiff.FieldAPI;
import jdiff.MethodAPI;
import jdiff.Modifiers;
import jdiff.PackageAPI;
import jdiff.ParamAPI;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLToAPI {
    private static API api_ = null;
    public static boolean validateXML = false;
    private static boolean showExceptionTypes = true;

    private XMLToAPI() {
    }

    public static API readFile(String filename, boolean createGlobalComments, String apiName) {
        api_ = new API();
        XMLToAPI.api_.name_ = apiName;
        try {
            XMLReader parser = null;
            APIHandler handler = new APIHandler(api_, createGlobalComments);
            try {
                String parserName = System.getProperty("org.xml.sax.driver");
                parser = parserName == null ? XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser") : XMLReaderFactory.createXMLReader();
            }
            catch (SAXException saxe) {
                System.out.println("SAXException: " + saxe);
                saxe.printStackTrace();
                System.exit(1);
            }
            if (validateXML) {
                parser.setFeature("http://xml.org/sax/features/namespaces", true);
                parser.setFeature("http://xml.org/sax/features/validation", true);
                parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            parser.setContentHandler(handler);
            parser.setErrorHandler(handler);
            parser.parse(new InputSource(new FileInputStream(new File(filename))));
        }
        catch (SAXNotRecognizedException snre) {
            System.out.println("SAX Parser does not recognize feature: " + snre);
            snre.printStackTrace();
            System.exit(1);
        }
        catch (SAXNotSupportedException snse) {
            System.out.println("SAX Parser feature is not supported: " + snse);
            snse.printStackTrace();
            System.exit(1);
        }
        catch (SAXException saxe) {
            System.out.println("SAX Exception parsing file '" + filename + "' : " + saxe);
            saxe.printStackTrace();
            System.exit(1);
        }
        catch (IOException ioe) {
            System.out.println("IOException parsing file '" + filename + "' : " + ioe);
            ioe.printStackTrace();
            System.exit(1);
        }
        XMLToAPI.addInheritedElements();
        return api_;
    }

    public static void addInheritedElements() {
        for (PackageAPI pkg : XMLToAPI.api_.packages_) {
            for (ClassAPI cls : pkg.classes_) {
                ClassAPI parent;
                if (cls.extends_ != null && (parent = (ClassAPI)XMLToAPI.api_.classes_.get(cls.extends_)) != null) {
                    XMLToAPI.addInheritedElements(cls, parent, cls.extends_);
                }
                if (cls.implements_.size() == 0) continue;
                for (String implName : cls.implements_) {
                    ClassAPI parent2 = (ClassAPI)XMLToAPI.api_.classes_.get(implName);
                    if (parent2 == null) continue;
                    XMLToAPI.addInheritedElements(cls, parent2, implName);
                }
            }
        }
    }

    public static void addInheritedElements(ClassAPI child, ClassAPI parent, String fqParentName) {
        ClassAPI parent2;
        if (parent.methods_.size() != 0) {
            for (MethodAPI m : parent.methods_) {
                boolean overridden = false;
                for (MethodAPI localM : child.methods_) {
                    if (localM.name_.compareTo(m.name_) != 0 || localM.getSignature().compareTo(m.getSignature()) != 0) continue;
                    overridden = true;
                }
                if (overridden || m.inheritedFrom_ != null || m.modifiers_.visibility == null || m.modifiers_.visibility.compareTo("private") == 0) continue;
                MethodAPI m2 = new MethodAPI(m);
                m2.inheritedFrom_ = fqParentName;
                child.methods_.add(m2);
            }
        }
        if (parent.fields_.size() != 0) {
            for (FieldAPI f : parent.fields_) {
                if (child.fields_.indexOf(f) != -1 || f.inheritedFrom_ != null || f.modifiers_.visibility == null || f.modifiers_.visibility.compareTo("private") == 0) continue;
                FieldAPI f2 = new FieldAPI(f);
                f2.inheritedFrom_ = fqParentName;
                child.fields_.add(f2);
            }
        }
        if (parent.extends_ != null && (parent2 = (ClassAPI)XMLToAPI.api_.classes_.get(parent.extends_)) != null) {
            XMLToAPI.addInheritedElements(child, parent2, parent.extends_);
        }
        if (parent.implements_.size() != 0) {
            for (String implName : parent.implements_) {
                ClassAPI parent22 = (ClassAPI)XMLToAPI.api_.classes_.get(implName);
                if (parent22 == null) continue;
                XMLToAPI.addInheritedElements(child, parent22, implName);
            }
        }
    }

    public static void nameAPI(String name) {
        if (name == null) {
            System.out.println("Error: no API identifier found in the XML file '" + XMLToAPI.api_.name_ + "'");
            System.exit(3);
        }
        String filename2 = name.replace(' ', '_');
        if ((filename2 = filename2 + ".xml").compareTo(XMLToAPI.api_.name_) != 0) {
            System.out.println("Warning: API identifier in the XML file (" + name + ") differs from the name of the file '" + XMLToAPI.api_.name_ + "'");
        }
        XMLToAPI.api_.name_ = name;
    }

    public static void addPackage(String name) {
        XMLToAPI.api_.currPkg_ = new PackageAPI(name);
        XMLToAPI.api_.packages_.add(XMLToAPI.api_.currPkg_);
    }

    public static void addClass(String name, String parent, boolean isAbstract, Modifiers modifiers) {
        XMLToAPI.api_.currClass_ = new ClassAPI(name, parent, false, isAbstract, modifiers);
        XMLToAPI.api_.currPkg_.classes_.add(XMLToAPI.api_.currClass_);
        String fqName = XMLToAPI.api_.currPkg_.name_ + "." + name;
        ClassAPI caOld = XMLToAPI.api_.classes_.put(fqName, XMLToAPI.api_.currClass_);
        if (caOld != null) {
            System.out.println("Warning: duplicate class : " + fqName + " found. Using the first instance only.");
        }
    }

    public static void addInterface(String name, String parent, boolean isAbstract, Modifiers modifiers) {
        XMLToAPI.api_.currClass_ = new ClassAPI(name, parent, true, isAbstract, modifiers);
        XMLToAPI.api_.currPkg_.classes_.add(XMLToAPI.api_.currClass_);
    }

    public static void addImplements(String name) {
        XMLToAPI.api_.currClass_.implements_.add(name);
    }

    public static void addCtor(String type, Modifiers modifiers) {
        String t = type;
        if (t == null) {
            t = "void";
        }
        XMLToAPI.api_.currCtor_ = new ConstructorAPI(t, modifiers);
        XMLToAPI.api_.currClass_.ctors_.add(XMLToAPI.api_.currCtor_);
    }

    public static void addMethod(String name, String returnType, boolean isAbstract, boolean isNative, boolean isSynchronized, Modifiers modifiers) {
        String rt = returnType;
        if (rt == null) {
            rt = "void";
        }
        XMLToAPI.api_.currMethod_ = new MethodAPI(name, rt, isAbstract, isNative, isSynchronized, modifiers);
        XMLToAPI.api_.currClass_.methods_.add(XMLToAPI.api_.currMethod_);
    }

    public static void addField(String name, String type, boolean isTransient, boolean isVolatile, String value, Modifiers modifiers) {
        String t = type;
        if (t == null) {
            t = "void";
        }
        XMLToAPI.api_.currField_ = new FieldAPI(name, t, isTransient, isVolatile, value, modifiers);
        XMLToAPI.api_.currClass_.fields_.add(XMLToAPI.api_.currField_);
    }

    public static void addParam(String name, String type) {
        String t = type;
        if (t == null) {
            t = "void";
        }
        ParamAPI paramAPI = new ParamAPI(name, t);
        XMLToAPI.api_.currMethod_.params_.add(paramAPI);
    }

    public static void addException(String name, String type, String currElement) {
        String exceptionId = type;
        if (type == null || !showExceptionTypes) {
            exceptionId = name;
        }
        if (currElement.compareTo("method") == 0) {
            XMLToAPI.api_.currMethod_.exceptions_ = XMLToAPI.api_.currMethod_.exceptions_.compareTo("no exceptions") == 0 ? exceptionId : XMLToAPI.api_.currMethod_.exceptions_ + ", " + exceptionId;
        } else {
            XMLToAPI.api_.currCtor_.exceptions_ = XMLToAPI.api_.currCtor_.exceptions_.compareTo("no exceptions") == 0 ? exceptionId : XMLToAPI.api_.currCtor_.exceptions_ + ", " + exceptionId;
        }
    }
}

