/*
 * Decompiled with CFR 0.152.
 */
package jdiff;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import jdiff.Comments;
import jdiff.JDiff;
import jdiff.SingleComment;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class CommentsHandler
extends DefaultHandler {
    public Comments comments_ = null;
    private List currSingleComment_ = null;
    private boolean inText = false;
    private String currentText = null;
    private LinkedList tagStack = null;
    private static final boolean trace = false;

    public CommentsHandler(Comments comments) {
        this.comments_ = comments;
        this.tagStack = new LinkedList();
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (localName.equals("")) {
            localName = qName;
        }
        if (localName.compareTo("comments") == 0) {
            String commentsName = attributes.getValue("name");
            String version = attributes.getValue("jdversion");
            if (commentsName == null) {
                System.out.println("Error: no identifier found in the comments XML file.");
                System.exit(3);
            }
            int idx1 = JDiff.oldFileName.lastIndexOf(46);
            int idx2 = JDiff.newFileName.lastIndexOf(46);
            String filename2 = JDiff.oldFileName.substring(0, idx1) + "_to_" + JDiff.newFileName.substring(0, idx2);
            if (filename2.compareTo(commentsName) != 0) {
                System.out.println("Warning: API identifier in the comments XML file (" + filename2 + ") differs from the name of the file.");
            }
        } else if (localName.compareTo("comment") == 0) {
            this.currSingleComment_ = new ArrayList();
        } else if (localName.compareTo("identifier") == 0) {
            String id = attributes.getValue("id");
            SingleComment newComment = new SingleComment(id, null);
            this.currSingleComment_.add(newComment);
        } else if (localName.compareTo("text") == 0) {
            this.inText = true;
            this.currentText = null;
        } else if (this.inText) {
            this.addStartTagToText(localName, attributes);
        } else {
            System.out.println("Error: unknown element type: " + localName);
            System.exit(-1);
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (localName.equals("")) {
            localName = qName;
        }
        if (localName.compareTo("text") == 0) {
            this.inText = false;
            this.addTextToComments();
        } else if (this.inText) {
            this.addEndTagToText(localName);
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inText) {
            String chunk = new String(ch, start, length);
            this.currentText = this.currentText == null ? chunk : this.currentText + chunk;
        }
    }

    public void addTextToComments() {
        this.currentText = this.currentText.trim();
        if (!(this.currentText.endsWith(".") || this.currentText.endsWith("?") || this.currentText.endsWith("!") || this.currentText.compareTo("InsertCommentsHere") == 0)) {
            System.out.println("Warning: text of comment does not end in a period: " + this.currentText);
        }
        for (SingleComment currComment : this.currSingleComment_) {
            currComment.text_ = currComment.text_ == null ? this.currentText : currComment.text_ + this.currentText;
            this.comments_.addComment(currComment);
        }
    }

    public void addStartTagToText(String localName, Attributes attributes) {
        String currentHTMLTag = localName;
        this.tagStack.add(currentHTMLTag);
        String tag = "<" + currentHTMLTag;
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            tag = tag + " " + name + "=\"" + value + "\"";
        }
        tag = Comments.isMinimizedTag(currentHTMLTag) ? tag + "/>" : tag + ">";
        this.currentText = this.currentText == null ? tag : this.currentText + tag;
    }

    public void addEndTagToText(String localName) {
        String currentHTMLTag = (String)this.tagStack.removeLast();
        if (!Comments.isMinimizedTag(currentHTMLTag)) {
            this.currentText = this.currentText + "</" + currentHTMLTag + ">";
        }
    }

    public void warning(SAXParseException e) {
        System.out.println("Warning (" + e.getLineNumber() + "): parsing XML comments file:" + e);
        e.printStackTrace();
    }

    public void error(SAXParseException e) {
        System.out.println("Error (" + e.getLineNumber() + "): parsing XML comments file:" + e);
        e.printStackTrace();
        System.exit(1);
    }

    public void fatalError(SAXParseException e) {
        System.out.println("Fatal Error (" + e.getLineNumber() + "): parsing XML comments file:" + e);
        e.printStackTrace();
        System.exit(1);
    }
}

