/*
 * Decompiled with CFR 0.152.
 */
package jdiff;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import jdiff.APIDiff;
import jdiff.ClassDiff;
import jdiff.CompareClassPdiffs;
import jdiff.ComparePkgPdiffs;
import jdiff.Diff;
import jdiff.HTMLReportGenerator;
import jdiff.PackageDiff;

public class HTMLStatistics {
    private HTMLReportGenerator h_ = null;

    public HTMLStatistics(HTMLReportGenerator h) {
        this.h_ = h;
    }

    public void emitStatistics(String filename, APIDiff apiDiff) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            HTMLReportGenerator.reportFile = new PrintWriter(fos);
            this.h_.writeStartHTMLHeader();
            this.h_.writeHTMLTitle("JDiff Statistics");
            this.h_.writeStyleSheetRef();
            this.h_.writeText("</HEAD>");
            this.h_.writeText("<BODY>");
            this.h_.writeText("<!-- Start of nav bar -->");
            this.h_.writeText("<TABLE summary=\"Navigation bar\" BORDER=\"0\" WIDTH=\"100%\" CELLPADDING=\"1\" CELLSPACING=\"0\">");
            this.h_.writeText("<TR>");
            this.h_.writeText("<TD COLSPAN=2 BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1\">");
            this.h_.writeText("  <TABLE summary=\"Navigation bar\" BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"3\">");
            this.h_.writeText("    <TR ALIGN=\"center\" VALIGN=\"top\">");
            this.h_.writeText("      <TD BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1\"> <A HREF=\"" + HTMLReportGenerator.newDocPrefix + "index.html\" target=\"_top\"><FONT CLASS=\"NavBarFont1\"><B><tt>" + APIDiff.newAPIName_ + "</tt></B></FONT></A>&nbsp;</TD>");
            this.h_.writeText("      <TD BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1\"> <A HREF=\"" + HTMLReportGenerator.reportFileName + "-summary" + HTMLReportGenerator.reportFileExt + "\"><FONT CLASS=\"NavBarFont1\"><B>Overview</B></FONT></A>&nbsp;</TD>");
            this.h_.writeText("      <TD BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1\"> &nbsp;<FONT CLASS=\"NavBarFont1\">Package</FONT>&nbsp;</TD>");
            this.h_.writeText("      <TD BGCOLOR=\"#FFFFFF\" CLASS=\"NavBarCell1\"> &nbsp;<FONT CLASS=\"NavBarFont1\">Class</FONT>&nbsp;</TD>");
            if (!Diff.noDocDiffs) {
                this.h_.writeText("      <TD BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1\"> <A HREF=\"" + Diff.diffFileName + "index" + HTMLReportGenerator.reportFileExt + "\"><FONT CLASS=\"NavBarFont1\"><B>Text Changes</B></FONT></A>&nbsp;</TD>");
            }
            this.h_.writeText("      <TD BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1Rev\"> &nbsp;<FONT CLASS=\"NavBarFont1Rev\"><B>Statistics</B></FONT>&nbsp;</TD>");
            this.h_.writeText("      <TD BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1\"> <A HREF=\"jdiff_help" + HTMLReportGenerator.reportFileExt + "\"><FONT CLASS=\"NavBarFont1\"><B>Help</B></FONT></A>&nbsp;</TD>");
            this.h_.writeText("    </TR>");
            this.h_.writeText("  </TABLE>");
            this.h_.writeText("</TD>");
            this.h_.writeText("<TD ALIGN=\"right\" VALIGN=\"top\" ROWSPAN=3><EM><b>Generated by<br><a href=\"http://www.jdiff.org\" class=\"staysblack\" target=\"_top\">JDiff</a></b></EM></TD>");
            this.h_.writeText("</TR>");
            this.h_.writeText("<TR>");
            this.h_.writeText("  <TD BGCOLOR=\"" + "#FFFFFF" + "\" CLASS=\"NavBarCell2\"><FONT SIZE=\"-2\"></FONT>");
            this.h_.writeText("</TD>");
            this.h_.writeText("  <TD BGCOLOR=\"" + "#FFFFFF" + "\" CLASS=\"NavBarCell2\"><FONT SIZE=\"-2\">");
            this.h_.writeText("  <A HREF=\"../" + HTMLReportGenerator.reportFileName + HTMLReportGenerator.reportFileExt + "\" TARGET=\"_top\"><B>FRAMES</B></A>  &nbsp;");
            this.h_.writeText("  &nbsp;<A HREF=\"jdiff_statistics" + HTMLReportGenerator.reportFileExt + "\" TARGET=\"_top\"><B>NO FRAMES</B></A></FONT></TD>");
            this.h_.writeText("</TR>");
            this.h_.writeText("</TABLE>");
            this.h_.writeText("<HR>");
            this.h_.writeText("<!-- End of nav bar -->");
            this.h_.writeText("<center>");
            this.h_.writeText("<H1>JDiff Statistics</H1>");
            this.h_.writeText("</center>");
            this.h_.writeText("<BLOCKQUOTE>");
            this.h_.writeText("The percent change statistic reported for all elements in each API is defined recursively as follows:<br>");
            this.h_.writeText("<pre>");
            this.h_.writeText("Percentage difference = 100 * (added + removed + 2*changed)");
            this.h_.writeText("                        -----------------------------------");
            this.h_.writeText("                        sum of public elements in BOTH APIs");
            this.h_.writeText("</pre>");
            this.h_.writeText("Where <code>added</code> is the number of packages added, <code>removed</code> is the number of packages removed, and <code>changed</code> is the number of packages changed.");
            this.h_.writeText("This definition is applied recursively for the classes and their program elements, so the value for a changed package will be less than 1, unless every class in that package has changed.");
            this.h_.writeText("The definition ensures that if all packages are removed and all new packages are");
            this.h_.writeText("added, the change will be 100%. Values are rounded here, so a value of 0% indicates a percentage difference of less than 0.5%.");
            this.h_.writeText("<p>The overall difference between the two APIs is approximately " + (int)apiDiff.pdiff + "%.");
            this.h_.writeText("</BLOCKQUOTE>");
            this.h_.writeText("<h3>Sections</h3>");
            this.h_.writeText("<a href=\"#packages\">Packages</a> sorted by percentage difference<br>");
            this.h_.writeText("<a href=\"#classes\">Classes and <i>Interfaces</i></a> sorted by percentage difference<br>");
            this.h_.writeText("<a href=\"#numbers\">Differences</a> by number and type<br>");
            this.h_.writeText("<hr>");
            this.h_.writeText("<a name=\"packages\"></a>");
            this.h_.writeText("<h2>Packages Sorted By Percentage Difference</h2>");
            this.emitPackagesByDiff(apiDiff);
            this.h_.writeText("<hr>");
            this.h_.writeText("<a name=\"classes\"></a>");
            this.h_.writeText("<h2>Classes and <i>Interfaces</i> Sorted By Percentage Difference</h2>");
            this.emitClassesByDiff(apiDiff);
            this.h_.writeText("<hr>");
            this.h_.writeText("<a name=\"numbers\"></a>");
            this.h_.writeText("<h2>Differences By Number and Type</h2>");
            this.h_.writeText("<BLOCKQUOTE>");
            this.h_.writeText("The numbers of program elements (packages, classes. constructors, methods and fields) which are recorded as removed, added or changed includes only the highest-level program elements. That is, if a class with two methods was added, the number of methods added does not include those two methods, but the number of classes added does include that class.");
            this.h_.writeText("</BLOCKQUOTE>");
            this.emitNumbersByElement(apiDiff);
            this.h_.writeText("</HTML>");
            HTMLReportGenerator.reportFile.close();
        }
        catch (IOException e) {
            System.out.println("IO Error while attempting to create " + filename);
            System.out.println("Error: " + e.getMessage());
            System.exit(1);
        }
    }

    public void emitPackagesByDiff(APIDiff apiDiff) {
        int i;
        Collections.sort(apiDiff.packagesChanged, new ComparePkgPdiffs());
        this.h_.writeText("<TABLE summary=\"Packages sorted by percentage difference\" BORDER=\"1\" WIDTH=\"100%\" cellspacing=\"0\" cellpadding=\"0\">");
        this.h_.writeText("<TR WIDTH=\"20%\">");
        this.h_.writeText("  <TD ALIGN=\"center\" bgcolor=\"#EEEEFF\"><FONT size=\"+1\"><b>Percentage<br>Difference</b></FONT></TD>");
        this.h_.writeText("  <TD ALIGN=\"center\" bgcolor=\"#EEEEFF\"><FONT size=\"+1\"><b>Package</b></FONT></TD>");
        this.h_.writeText("</TR>");
        int[] hist = new int[101];
        for (int i2 = 0; i2 < 101; ++i2) {
            hist[i2] = 0;
        }
        for (PackageDiff pkg : apiDiff.packagesChanged) {
            int bucket;
            int n = bucket = (int)pkg.pdiff;
            hist[n] = hist[n] + 1;
            this.h_.writeText("<TR>");
            if (bucket != 0) {
                this.h_.writeText("  <TD ALIGN=\"center\">" + bucket + "</TD>");
            } else {
                this.h_.writeText("  <TD ALIGN=\"center\">&lt;1</TD>");
            }
            this.h_.writeText("  <TD><A HREF=\"pkg_" + pkg.name_ + HTMLReportGenerator.reportFileExt + "\">" + pkg.name_ + "</A></TD>");
            this.h_.writeText("</TR>");
        }
        this.h_.writeText("</TABLE>");
        this.h_.writeText("<hr>");
        this.h_.writeText("<p><a name=\"packages_hist\"></a>");
        this.h_.writeText("<TABLE summary=\"Histogram of the package percentage differences\" BORDER=\"1\" cellspacing=\"0\" cellpadding=\"0\">");
        this.h_.writeText("<TR>");
        this.h_.writeText("  <TD ALIGN=\"center\" bgcolor=\"#EEEEFF\"><FONT size=\"+1\"><b>Percentage<br>Difference</b></FONT></TD>");
        this.h_.writeText("  <TD ALIGN=\"center\" bgcolor=\"#EEEEFF\"><FONT size=\"+1\"><b>Frequency</b></FONT></TD>");
        this.h_.writeText("  <TD width=\"300\" ALIGN=\"center\" bgcolor=\"#EEEEFF\"><FONT size=\"+1\"><b>Percentage Frequency</b></FONT></TD>");
        this.h_.writeText("</TR>");
        double total = 0.0;
        for (i = 0; i < 101; ++i) {
            total += (double)hist[i];
        }
        for (i = 0; i < 101; ++i) {
            if (hist[i] == 0) continue;
            this.h_.writeText("<TR>");
            this.h_.writeText("  <TD ALIGN=\"center\">" + i + "</TD>");
            this.h_.writeText("  <TD>" + (double)hist[i] / total + "</TD>");
            this.h_.writeText("  <TD><img alt=\"|\" src=\"../black.gif\" height=20 width=" + (double)(hist[i] * 300) / total + "></TD>");
            this.h_.writeText("</TR>");
        }
        this.h_.writeText("<!-- START_PACKAGE_HISTOGRAM");
        for (i = 0; i < 101; ++i) {
            if (hist[i] == 0) continue;
            this.h_.writeText(i + "," + (double)hist[i] / total);
        }
        this.h_.writeText("END_PACKAGE_HISTOGRAM -->");
        this.h_.writeText("</TABLE>");
    }

    public void emitClassesByDiff(APIDiff apiDiff) {
        int i;
        ArrayList allChangedClasses = new ArrayList();
        for (PackageDiff pkg : apiDiff.packagesChanged) {
            if (pkg.classesChanged == null) continue;
            ArrayList cc = new ArrayList(pkg.classesChanged);
            for (ClassDiff classDiff : cc) {
                classDiff.name_ = pkg.name_ + "." + classDiff.name_;
            }
            allChangedClasses.addAll(cc);
        }
        Collections.sort(allChangedClasses, new CompareClassPdiffs());
        this.h_.writeText("<TABLE summary=\"Classes sorted by percentage difference\" BORDER=\"1\" WIDTH=\"100%\" cellspacing=\"0\" cellpadding=\"0\">");
        this.h_.writeText("<TR WIDTH=\"20%\">");
        this.h_.writeText("  <TD ALIGN=\"center\" bgcolor=\"#EEEEFF\"><FONT size=\"+1\"><b>Percentage<br>Difference</b></FONT></TD>");
        this.h_.writeText("  <TD ALIGN=\"center\" bgcolor=\"#EEEEFF\"><FONT size=\"+1\"><b>Class or <i>Interface</i></b></FONT></TD>");
        this.h_.writeText("</TR>");
        int[] hist = new int[101];
        for (int i2 = 0; i2 < 101; ++i2) {
            hist[i2] = 0;
        }
        for (ClassDiff classDiff : allChangedClasses) {
            int bucket;
            int n = bucket = (int)classDiff.pdiff;
            hist[n] = hist[n] + 1;
            this.h_.writeText("<TR>");
            if (bucket != 0) {
                this.h_.writeText("  <TD ALIGN=\"center\">" + bucket + "</TD>");
            } else {
                this.h_.writeText("  <TD ALIGN=\"center\">&lt;1</TD>");
            }
            this.h_.writeText("  <TD><A HREF=\"" + classDiff.name_ + HTMLReportGenerator.reportFileExt + "\">");
            if (classDiff.isInterface_) {
                this.h_.writeText("<i>" + classDiff.name_ + "</i></A></TD>");
            } else {
                this.h_.writeText(classDiff.name_ + "</A></TD>");
            }
            this.h_.writeText("</TR>");
        }
        this.h_.writeText("</TABLE>");
        this.h_.writeText("<hr>");
        this.h_.writeText("<p><a name=\"classes_hist\"></a>");
        this.h_.writeText("<TABLE summary=\"Histogram of the class percentage differences\" BORDER=\"1\" cellspacing=\"0\" cellpadding=\"0\">");
        this.h_.writeText("<TR>");
        this.h_.writeText("  <TD ALIGN=\"center\" bgcolor=\"#EEEEFF\"><FONT size=\"+1\"><b>Percentage<br>Difference</b></FONT></TD>");
        this.h_.writeText("  <TD ALIGN=\"center\" bgcolor=\"#EEEEFF\"><FONT size=\"+1\"><b>Frequency</b></FONT></TD>");
        this.h_.writeText("  <TD width=\"300\" ALIGN=\"center\" bgcolor=\"#EEEEFF\"><FONT size=\"+1\"><b>Percentage Frequency</b></FONT></TD>");
        this.h_.writeText("</TR>");
        double total = 0.0;
        for (i = 0; i < 101; ++i) {
            total += (double)hist[i];
        }
        for (i = 0; i < 101; ++i) {
            if (hist[i] == 0) continue;
            this.h_.writeText("<TR>");
            this.h_.writeText("  <TD ALIGN=\"center\">" + i + "</TD>");
            this.h_.writeText("  <TD>" + (double)hist[i] / total + "</TD>");
            this.h_.writeText("  <TD><img alt=\"|\" src=\"../black.gif\" height=20 width=" + (double)(hist[i] * 300) / total + "></TD>");
            this.h_.writeText("</TR>");
        }
        this.h_.writeText("<!-- START_CLASS_HISTOGRAM");
        for (i = 0; i < 101; ++i) {
            if (hist[i] == 0) continue;
            this.h_.writeText(i + "," + (double)hist[i] / total);
        }
        this.h_.writeText("END_CLASS_HISTOGRAM -->");
        this.h_.writeText("</TABLE>");
    }

    public void emitNumbersByElement(APIDiff apiDiff) {
        int numPackagesRemoved = apiDiff.packagesRemoved.size();
        int numPackagesAdded = apiDiff.packagesAdded.size();
        int numPackagesChanged = apiDiff.packagesChanged.size();
        int numClassesRemoved = 0;
        int numClassesAdded = 0;
        int numClassesChanged = 0;
        int numCtorsRemoved = 0;
        int numCtorsAdded = 0;
        int numCtorsChanged = 0;
        int numMethodsRemoved = 0;
        int numMethodsAdded = 0;
        int numMethodsChanged = 0;
        int numFieldsRemoved = 0;
        int numFieldsAdded = 0;
        int numFieldsChanged = 0;
        int numRemoved = 0;
        int numAdded = 0;
        int numChanged = 0;
        for (PackageDiff pkg : apiDiff.packagesChanged) {
            numClassesRemoved += pkg.classesRemoved.size();
            numClassesAdded += pkg.classesAdded.size();
            numClassesChanged += pkg.classesChanged.size();
            for (ClassDiff classDiff : pkg.classesChanged) {
                numCtorsRemoved += classDiff.ctorsRemoved.size();
                numCtorsAdded += classDiff.ctorsAdded.size();
                numCtorsChanged += classDiff.ctorsChanged.size();
                numMethodsRemoved += classDiff.methodsRemoved.size();
                numMethodsAdded += classDiff.methodsAdded.size();
                numMethodsChanged += classDiff.methodsChanged.size();
                numFieldsRemoved += classDiff.fieldsRemoved.size();
                numFieldsAdded += classDiff.fieldsAdded.size();
                numFieldsChanged += classDiff.fieldsChanged.size();
            }
        }
        this.h_.writeText("<TABLE summary=\"Number of differences\" BORDER=\"1\" WIDTH=\"100%\" cellspacing=\"0\" cellpadding=\"0\">");
        this.h_.writeText("<TR>");
        this.h_.writeText("  <TD COLSPAN=5 ALIGN=\"center\" NOWRAP bgcolor=\"#EEEEFF\"><FONT size=\"+1\">");
        this.h_.writeText("  <B>Number of Differences</B></FONT></TD>");
        this.h_.writeText("</TR>");
        this.h_.writeText("<TR>");
        this.h_.writeText("  <TD>&nbsp;</TD>");
        this.h_.writeText("  <TD ALIGN=\"center\"><b>Removals</b></TD>");
        this.h_.writeText("  <TD ALIGN=\"center\"><b>Additions</b></TD>");
        this.h_.writeText("  <TD ALIGN=\"center\"><b>Changes</b></TD>");
        this.h_.writeText("  <TD ALIGN=\"center\"><b>Total</b></TD>");
        this.h_.writeText("</TR>");
        this.h_.writeText("<TR>");
        this.h_.writeText("  <TD>Packages</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numPackagesRemoved + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numPackagesAdded + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numPackagesChanged + "</TD>");
        int numPackages = numPackagesRemoved + numPackagesAdded + numPackagesChanged;
        this.h_.writeText("  <TD ALIGN=\"right\">" + numPackages + "</TD>");
        this.h_.writeText("</TR>");
        numRemoved += numPackagesRemoved;
        numAdded += numPackagesAdded;
        numChanged += numPackagesChanged;
        this.h_.writeText("<TR>");
        this.h_.writeText("  <TD>Classes and <i>Interfaces</i></TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numClassesRemoved + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numClassesAdded + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numClassesChanged + "</TD>");
        int numClasses = numClassesRemoved + numClassesAdded + numClassesChanged;
        this.h_.writeText("  <TD ALIGN=\"right\">" + numClasses + "</TD>");
        this.h_.writeText("</TR>");
        numRemoved += numClassesRemoved;
        numAdded += numClassesAdded;
        numChanged += numClassesChanged;
        this.h_.writeText("<TR>");
        this.h_.writeText("  <TD>Constructors</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numCtorsRemoved + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numCtorsAdded + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numCtorsChanged + "</TD>");
        int numCtors = numCtorsRemoved + numCtorsAdded + numCtorsChanged;
        this.h_.writeText("  <TD ALIGN=\"right\">" + numCtors + "</TD>");
        this.h_.writeText("</TR>");
        numRemoved += numCtorsRemoved;
        numAdded += numCtorsAdded;
        numChanged += numCtorsChanged;
        this.h_.writeText("<TR>");
        this.h_.writeText("  <TD>Methods</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numMethodsRemoved + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numMethodsAdded + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numMethodsChanged + "</TD>");
        int numMethods = numMethodsRemoved + numMethodsAdded + numMethodsChanged;
        this.h_.writeText("  <TD ALIGN=\"right\">" + numMethods + "</TD>");
        this.h_.writeText("</TR>");
        numRemoved += numMethodsRemoved;
        numAdded += numMethodsAdded;
        numChanged += numMethodsChanged;
        this.h_.writeText("<TR>");
        this.h_.writeText("  <TD>Fields</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numFieldsRemoved + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numFieldsAdded + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + numFieldsChanged + "</TD>");
        int numFields = numFieldsRemoved + numFieldsAdded + numFieldsChanged;
        this.h_.writeText("  <TD ALIGN=\"right\">" + numFields + "</TD>");
        this.h_.writeText("</TR>");
        this.h_.writeText("<TR>");
        this.h_.writeText("  <TD><b>Total</b></TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + (numRemoved += numFieldsRemoved) + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + (numAdded += numFieldsAdded) + "</TD>");
        this.h_.writeText("  <TD ALIGN=\"right\">" + (numChanged += numFieldsChanged) + "</TD>");
        int total = numRemoved + numAdded + numChanged;
        this.h_.writeText("  <TD ALIGN=\"right\">" + total + "</TD>");
        this.h_.writeText("</TR>");
        this.h_.writeText("</TABLE>");
    }
}

